﻿/*********************************************************************************
// This code is created by SimCoder Version 2021a0.5 for F2806x Hardware Target
//
// SimCoder is copyright by Powersim Inc., 2009-2019
//
// Date: November 16, 2021 12:49:05
**********************************************************************************/
#define GLOBAL_Q 24
long GlobalQ = GLOBAL_Q;      // Used for legacy GEL & Graph Debug.
#include	"IQmathLib.h"
#include	"PS_bios.h"
#define	GetCurTime() PS_GetSysTimer()
#define	PWM_IN_CHECK	// To lower PWM value setting time, comment out this line if PWM duty cycle values are strictly limited in the range.






interrupt void Task();
void Task_1();
void TaskS2();
void TaskS4();
void TaskS5();
void TaskPARK(_iq24 fIn0, _iq24 fIn1, _iq24 fIn2, _iq24 fIn3, _iq24 *fOut0, _iq24 *fOut1);
void TaskIPARK(_iq24 fIn0, _iq24 fIn1, _iq24 fIn2, _iq24 fIn3, _iq24 *fOut0, _iq24 *fOut1);


const Uint16 PSD_CpuClock = 90;  // MHz
extern	_iq	fGblVTa_p;
extern	_iq	fGblVTb_p;
extern	_iq	fGblVTc_p;
extern	_iq	fGblid;
extern	_iq	fGbliq;
extern	_iq	fGblCosin;
extern	_iq	fGblSine;
extern	_iq	fGblVerr;
extern	_iq	fGblUDELAY7;
extern	_iq	fGblUDELAY25;
extern	_iq	fGblUDELAY29;
extern	_iq	fGblIalfa;
extern	_iq	fGblUDELAY30;
extern	_iq	fGblUDELAY31;
extern	_iq	fGblUDELAY32;
extern	_iq	fGblUDELAY33;
extern	_iq	fGblIbeta;
extern	_iq	fGblUDELAY34;
extern	_iq	fGblUDELAY35;
extern	_iq	fGblUDELAY37;
extern	_iq	fGblUDELAY39;
extern	_iq	fGblUDELAY41;
extern	_iq	fGblUDELAY17;
extern	_iq	fGblS11;
extern	_iq	fGblIqref;
extern	_iq	fGblV73;
extern	_iq	fGblwe;
extern	_iq	fGblP80;
extern	_iq	fGblP83;
extern	_iq	fGblSpeedRef_pu;

void FGetValSPIIN();
interrupt void FSpiCmdStart0();

#define PS_AskDelayClk(delay, clkSpd) (((Uint32)(delay) + (Uint32)(500 / (clkSpd))) * 90 / 1000)
#define Csz_SPI_QUEUE		32	// SPI queue buffer size
#define Csz_SPI_DEVICES		1	// the number of all SPI devices
#define Cn_SPIIN	0	// the index of receiving command in PSA_SpiSendCmd.
#define Cr_SPIIN	0	// the index of receiving command in PSA_SpiRecvCmd.
#define SeqCn_SPIIN	0	// the index of receiving command in PSA_SpiInOut.

Uint16 PSA_SpiRecvCmd[1];
Uint16 PSA_SpiSendCmd[1] = {
	0xB800 		/* Cn_SPIIN*/
};

Uint16 PSA_SpiBBR[Csz_SPI_DEVICES * 2];
const PST_SpiDev PSA_SpiDev[Csz_SPI_DEVICES] = {
	{0, 5000, 0, (Uint16)PS_AskDelayClk(0, 5), &PSA_SpiBBR[0], NULL, NULL}};

const PST_SpiIo PSA_SpiInOut[] = {
	{{1, 0, 1, 0, 0}, &PSA_SpiSendCmd[Cn_SPIIN],
		&PSA_SpiRecvCmd[Cr_SPIIN], Task_1, FGetValSPIIN, 0}};

Uint16 PSA_SpiQueue[Csz_SPI_QUEUE];	// SPI queue buffer







PST_BufItem aGblSciOutBuf[1024];
PST_Data aGblSciInValue[1] = {_IQ24(0.5)};
Uint16 aGblSciOutAllow[10] = {0,0,0,0,0,0,0,0,0,0};
Uint16 aGblSciOutCnt[10] = {0,0,0,0,0,0,0,0,0,0};
Uint16 nGblSciState = 0;
Uint16 aGblSciDateSetPt[10] = {1,1,1,1,1,1,1,1,1,1};
char* aGblSciInitStr = "\0015.24,1:Ia_fb=15000\003\0015.24,2:Va_fb=15000\003\0015.24,3:Iaf=15000\003\0015.24,4:Ibf=15000\003\0015.24,5:PSM_thetaE=15000\003\0015.24,6:Eafe=15000\003\0015.24,7:Ebfe=15000\003\0015.24,8:Vbf=15000\003\0015.24,9:Vaf=15000\003\0015.24,10:speed_est_pu=1000\003\0010.24,1:SpeedRef_kRPM=0.5\003";
#define	PSC_SCI_SENDOUT_FLAG	0x2000
#define	PSC_SCI_INITIAL		0
#define	PSC_SCI_START		0x5000000
#define	PSC_SCI_PAUSE		0x1000000
#define	PSC_SCI_RESTART		0x2000000
#define	PSC_SCI_CONT_MODE	0x3000000
#define	PSC_SCI_SNAP_MODE	0x4000000
#define	PSC_SCI_CONT_START	1
#define	PSC_SCI_CONT_BEGIN	2
#define	PSC_SCI_CONT_SEND	3
#define	PSC_SCI_CONT_PAUSE	4
#define	PSC_SCI_SNAP_START	100
#define	PSC_SCI_SNAP_BEGIN	101
#define	PSC_SCI_SNAP_SEND	102
#define	PSC_SCI_SNAP_WAIT	103
#define	PSC_SCI_SNAP_PSEND	104
#define	PSC_SCI_SNAP_PWAIT	105
#define	PSC_SCI_SNAP_PAUSE	106
void _ProcSciInputItem(PST_BufItem* pItem)
{
	Uint16 i, nSeqNo = pItem->nSeqNo.bit.nSeqNo;
	switch (nSeqNo) {
	case 0:
		switch (pItem->data.dataInt32) {
		case PSC_SCI_INITIAL:
			for (i = 0; i < 10; i++) aGblSciOutAllow[i] = 0;
			PS_SciClearSendBuf();
			PS_SciSendInitStr(aGblSciInitStr);
			break;
		case PSC_SCI_PAUSE:
			PS_DisableIntr();
			switch (nGblSciState) {
			case PSC_SCI_CONT_START:
			case PSC_SCI_CONT_SEND:
				PS_SciClearSendBuf();
				nGblSciState = PSC_SCI_CONT_PAUSE;
				break;
			case PSC_SCI_SNAP_SEND:
				nGblSciState = PSC_SCI_SNAP_PSEND;
				break;
			case PSC_SCI_SNAP_WAIT:
				nGblSciState = PSC_SCI_SNAP_PWAIT;
				break;
			default:
				break;
			}
			PS_EnableIntr();
			break;
		case PSC_SCI_RESTART:
			PS_DisableIntr();
			switch (nGblSciState) {
			case PSC_SCI_CONT_PAUSE:
				nGblSciState = PSC_SCI_CONT_START;
				break;
			case PSC_SCI_SNAP_PSEND:
			case PSC_SCI_SNAP_PWAIT:
			case PSC_SCI_SNAP_PAUSE:
				nGblSciState = PSC_SCI_SNAP_START;
				break;
			}
			PS_EnableIntr();
			break;
		case PSC_SCI_CONT_MODE:
			nGblSciState = PSC_SCI_CONT_START;
			break;
		case PSC_SCI_SNAP_MODE:
			nGblSciState = PSC_SCI_SNAP_START;
			break;
		default:
			if (pItem->nSeqNo.bit.nCount == 0) {
				for (i = 0; i < 10; i++) aGblSciOutAllow[i] = 0;
			}
			for (i = 0; i < 4; i++) {
				int index = (pItem->data.dataInt32 >> (i * 8)) & 0xff;
				if ((index > 0) && (index <= 10))
					aGblSciOutAllow[index - 1] = PSC_SCI_SENDOUT_FLAG;
			}
			break;
		}
		break;
	default:
		if (nSeqNo <= 1)
			aGblSciInValue[nSeqNo - 1].dataInt32 = pItem->data.dataInt32;
		break;
	}
}

void _ProcSciRestart(void)
{
	int i;
	PST_BufItem item;

	for (i = 0; i < 10; i++)
		aGblSciOutAllow[i] &= 0xff00;
	item.nSeqNo.all = 0;
	switch (nGblSciState++) {
	case PSC_SCI_CONT_BEGIN:
		PS_SciClearSendBuf();
		item.data.dataInt32 = 0;
		break;
	case PSC_SCI_SNAP_BEGIN:
		item.data.dataInt32 = 1;
		break;
	case PSC_SCI_SNAP_PWAIT:
		nGblSciState = PSC_SCI_SNAP_START;
	case PSC_SCI_SNAP_WAIT:
		item.data.dataInt32 = 255;
		break;
	}
	PS_SciSendItem(&item);
}

void _ProcSciWaitStart(void)
{
	PS_DisableIntr();
	switch (nGblSciState) {
	case PSC_SCI_CONT_START:
		nGblSciState = PSC_SCI_CONT_BEGIN;
		break;
	case PSC_SCI_SNAP_START:
		nGblSciState = PSC_SCI_SNAP_BEGIN;
		break;
	default:
		break;
	}
	PS_EnableIntr();
}

void _ProcSciOutput(int index, int32 fVal)
{
	PST_BufItem item;
	int ok = ((aGblSciOutAllow[index] & PSC_SCI_SENDOUT_FLAG) &&
		(++aGblSciOutCnt[index] >= aGblSciDateSetPt[index]));
	PS_DisableIntr();
	switch (nGblSciState) {
	case PSC_SCI_CONT_BEGIN:
	case PSC_SCI_SNAP_BEGIN:
		_ProcSciRestart();
		break;
	case PSC_SCI_CONT_SEND:
		if (ok) {
			aGblSciOutCnt[index] = 0;
			item.nSeqNo.bit.nCount = aGblSciOutAllow[index];
			item.nSeqNo.bit.nSeqNo = index + 1;
			item.data.dataInt32 = fVal;
			PS_SciSendItem(&item);
			aGblSciOutAllow[index]++;
			aGblSciOutAllow[index] &= ~0x100;
		}
		break;
	case PSC_SCI_SNAP_SEND:
	case PSC_SCI_SNAP_PSEND:
		if (ok) {
			aGblSciOutCnt[index] = 0;
			item.nSeqNo.bit.nCount = aGblSciOutAllow[index];
			item.nSeqNo.bit.nSeqNo = index + 1;
			item.data.dataInt32 = fVal;
			if (!PS_SciSendItem(&item)) {
				nGblSciState++;
			} else {
				aGblSciOutAllow[index]++;
				aGblSciOutAllow[index] &= ~0x100;
			}
		}
		break;
	case PSC_SCI_SNAP_WAIT:
		if (PS_IsTxQueueEmpty()) {
			nGblSciState = PSC_SCI_SNAP_START;
		}
		break;
	case PSC_SCI_SNAP_PWAIT:
		if (PS_IsTxQueueEmpty()) {
			nGblSciState = PSC_SCI_SNAP_PAUSE;
		}
		break;
	default:
		break;
	}
	PS_EnableIntr();
}

// Parameters in parameter file _ParamFile9
#define	USER_PWM_FREQ_kHz	15.0
#define	USER_NUM_PWM_TICKS_PER_ISR_TICK	1.0
#define	USER_MOTOR_TYPE	1.0
#define	USER_MOTOR_NUM_POLE_PAIRS	4.0
#define	USER_MOTOR_RATED_FLUX	0.1105788
#define	USER_MOTOR_Rr	0.0
#define	USER_MOTOR_Rs	0.1954528
#define	USER_MOTOR_Ls_d	0.0007417737
#define	USER_MOTOR_Ls_q	0.0007417737
#define	USER_MOTOR_MAX_CURRENT	5.0
#define	USER_MOTOR_RES_EST_CURRENT	1.0
#define	USER_MOTOR_IND_EST_CURRENT	(-1)
#define	USER_MOTOR_MAGNETIZING_CURRENT	0.0
#define	USER_MOTOR_FLUX_EST_FREQ_Hz	20.0
#define	USER_IQ_FULL_SCALE_CURRENT_A	24.0
#define	USER_IQ_FULL_SCALE_VOLTAGE_V	24.0
#define	USER_MAX_ACCEL_EST_Hzps	5.0
#define	USER_ADC_FULL_SCALE_VOLTAGE_V	44.302
#define	USER_ADC_FULL_SCALE_CURRENT_A	47.1429
#define	USER_VOLTAGE_FILTER_POLE_Hz	344.618
#define	NUM_ISR_TICKS_PER_CTRL_TICK	1.0
#define	NUM_CTRL_TICKS_PER_CURRENT_TICK	1.0
#define	NUM_CTRL_TICKS_PER_EST_TICK	1.0
#define	NUM_CTRL_TICKS_PER_SPEED_TICK	15.0
#define	NUM_CTRL_TICKS_PER_TRAJ_TICK	15.0
#define	USER_SYSTEM_FREQ_MHz	90.0
#define	USER_NUM_CURRENT_SENSORS	3.0
#define	USER_NUM_VOLTAGE_SENSORS	3.0
#define	USER_IQ_FULL_SCALE_FREQ_Hz	806.667
#define	USER_IDRATED_DELTA	0.00002
#define	USER_R_OVER_L_EST_FREQ_Hz	100.0
#define	MATH_PI	3.1415926535897932384626433832795
#define	USER_OFFSET_POLE_rps	20.0
#define	USER_FLUX_POLE_rps	100.0
#define	USER_MAX_ACCEL_Hzps	20.0
#define	USER_MAX_VS_MAG_PU	0.5
#define	USER_DIRECTION_POLE_rps	6.0
#define	USER_SPEED_POLE_rps	100.0
#define	USER_DCBUS_POLE_rps	100.0
#define	USER_FLUX_FRACTION	1.0
#define	SPEEDMAX_FRACTION_FOR_L_IDENT	1.0
#define	USER_POWERWARP_GAIN	1.0
#define	USER_EST_KAPPAQ	1.5
#define	IDRATED_FRACTION_FOR_L_IDENT	1.0
#define	IDRATED_FRACTION_FOR_RATED_FLUX	1.0
#define	USER_ZEROSPEEDLIMIT	0.00061983445
#define	USER_FORCE_ANGLE_FREQ_Hz	1.0
#define	USER_PWM_PERIOD_usec	66.666667
#define	USER_VOLTAGE_SF	1.8459167
#define	USER_CURRENT_SF	1.9642875
#define	USER_VOLTAGE_FILTER_POLE_rps	2165.2988
#define	USER_ISR_FREQ_Hz	15000.0
#define	USER_CTRL_FREQ_Hz	15000.0
#define	USER_TRAJ_FREQ_Hz	1000.0
#define	USER_EST_FREQ_Hz	15000.0
#define	USER_MAX_CURRENT_SLOPE	(4.1666667e-05)
#define	MAX_CURRENT_SLOPE_POWERWARP	(1.25e-05)
#define	USER_ISR_PERIOD_usec	66.666667
#define	USER_CTRL_PERIOD_usec	66.666667
#define	USER_CTRL_PERIOD_sec	(6.6666667e-05)
#define	MAX_NEGATIVE_ID_REF_CURRENT_A	(-2.5)
#define	flag_simulation	0.0
#define	VkRPM	3.35
#define	MInertia	(4.8018e-6)
#define	POLES	8.0
#define	Rs	0.1954528
#define	Ls_d	0.0007417737
#define	Ls_q	0.0007417737
#define	Kadc_i	0.59523864
#define	Kadc_v	0.55936869
#define	Kwr_s	0.082644594
#define	fsw_d	15000.0
#define	Kp_d	1.503595233
#define	Ki_d	0.010317465305
#define	Kpi_d	1.5035952
#define	Tpi_d	0.0064615353
#define	fsw_s	1000.0
#define	Kp_s	1.0
#define	Ki_s	0.01090908051
#define	Kpi_s	1.0
#define	Tpi_s	0.091666754
#define	I_A_offset	0.997648
#define	I_B_offset	1.000980
#define	I_C_offset	0.998795
#define	V_A_offset	0.496092
#define	V_B_offset	0.495401
#define	V_C_offset	0.496448
_iq	fGblVTa_p = 0;
_iq	fGblVTb_p = 0;
_iq	fGblVTc_p = 0;
_iq	fGblid = 0;
_iq	fGbliq = 0;
_iq	fGblCosin = 0;
_iq	fGblSine = 0;
_iq	fGblVerr = 0;
_iq	fGblUDELAY7 = 0;
_iq	fGblUDELAY25 = 0;
_iq	fGblUDELAY29 = 0;
_iq	fGblIalfa = 0;
_iq	fGblUDELAY30 = 0;
_iq	fGblUDELAY31 = 0;
_iq	fGblUDELAY32 = 0;
_iq	fGblUDELAY33 = 0;
_iq	fGblIbeta = 0;
_iq	fGblUDELAY34 = 0;
_iq	fGblUDELAY35 = 0;
_iq	fGblUDELAY37 = 0;
_iq	fGblUDELAY39 = 0;
_iq	fGblUDELAY41 = 0;
_iq	fGblUDELAY17 = 0;
_iq	fGblS11 = 0;
_iq	fGblIqref = 0;
PST_Data	fGblSPIIN = {0};
_iq	fGblV73 = 0;
_iq	fGblwe = 0;
_iq	fGblP80 = 0;
_iq	fGblP83 = 0;
_iq	fGblSpeedRef_pu = 0;
interrupt void Task()
{
	_iq24	fUDELAY17, fZOH37, fZOH38, fUDELAY41, fUDELAY39, fUDELAY37, fUDELAY35;
	_iq24	fSUM26, fP27, fUDELAY34, fB5, fSUMP30, fk2, fSUM25, fp1, fSUM12, fP75;
	_iq24	fP79, fUDELAY33, fUDELAY32, fSUM24, fP28, fUDELAY31, fP23, fUDELAY30;
	_iq24	fB4, fSUMP29, fk1, fSUM22, fP74, fSUM21, fP73, fP72, fCLARKEV_1, fCLARKEV;
	_iq24	fSUM11, fSUM10, fUDELAY29, fP24, fUDELAY25, fLIM37, fSUMP16, fMULT30;
	_iq24	fUDELAY7, fLIM10, fSUMP12, fMULT31, fSUM23, fMULT48, fZOH51, fI_RESET_I_D7;
	_iq24	fSUMP36, fMULT46, fP92, fMULT47, fP70, fZOH50, fI_RESET_I_D6, fSUM27;
	_iq24	fMULT43, fP91, fSIN_U6, fCOS_U5, fSUM9, fSVGEN_2, fSVGEN_1, fSVGEN;
	_iq24	fMULT12, fMULT11, fFunVar59, fFunVar56, fS12, fSUM13, fZOH25, fS10;
	_iq24	fSUM4, fFunVar66, fFunVar54, fCOS_U6, fSIN_U5, fLIMIT_RANGE11, fSUMP20;
	_iq24	fP93, fCLARKEI_1, fCLARKEI, fSUM7, fSUM8, fSUM6;
	_iq26	fKp_L;
	_iq28	fZOH35, fADC1_13, fZOH34, fADC1_12, fZOH33, fADC1_11, fZOH29, fADC1_15;
	_iq28	fZOH32, fADC1_5, fZOH28, fADC1_4, fZOH27, fADC1_3;
	_iq30	fC15, fC14, fKI_L, fm, fC12, fC11, fC10, fIdRef;

	fUDELAY7 = fGblUDELAY7;

	fUDELAY25 = fGblUDELAY25;

	fUDELAY29 = fGblUDELAY29;

	fUDELAY30 = fGblUDELAY30;

	fUDELAY31 = fGblUDELAY31;

	fUDELAY32 = fGblUDELAY32;

	fUDELAY33 = fGblUDELAY33;

	fUDELAY34 = fGblUDELAY34;

	fUDELAY35 = fGblUDELAY35;

	fUDELAY37 = fGblUDELAY37;

	fUDELAY39 = fGblUDELAY39;

	fUDELAY41 = fGblUDELAY41;

	fUDELAY17 = fGblUDELAY17;


	fIdRef = _IQ30(0); // 0
	fADC1_3 = _IQ28mpyIQX(PSM_AdcGetValBySoc(0), 12, _IQ30((Kadc_i * 3.3)), 30); // Get DC value from ADC_A3.
	fZOH27 = fADC1_3;
	fC10 = _IQ30(0.997648); // I_A_offset
	fSUM6 = ((fZOH27) >> 4) - ((fC10) >> 6);
	fADC1_4 = _IQ28mpyIQX(PSM_AdcGetValBySoc(1), 12, _IQ30((Kadc_i * 3.3)), 30); // Get DC value from ADC_A4.
	fZOH28 = fADC1_4;
	fC11 = _IQ30(1.00098); // I_B_offset
	fSUM8 = ((fZOH28) >> 4) - ((fC11) >> 6);
	fADC1_5 = _IQ28mpyIQX(PSM_AdcGetValBySoc(2), 12, _IQ30((Kadc_i * 3.3)), 30); // Get DC value from ADC_A5.
	fZOH32 = fADC1_5;
	fC12 = _IQ30(0.998795); // I_C_offset
	fSUM7 = ((fZOH32) >> 4) - ((fC12) >> 6);
	// ABC to alpha/beta transformation
	fCLARKEI = _IQ24mpyIQX(_IQ30(1.0/3.0), 30, fSUM6 - ((fSUM8) >> 1) - ((fSUM7) >> 1), (24-1));
	fCLARKEI_1 = _IQ24mpyIQX(_IQ30(0.57735027), 30, fSUM8 - fSUM7, 24); // uvw2ab
	fP93 = _IQ24mpyIQX(fGblUDELAY25, 24, _IQ30(4096.0 * (1.0/10000.0)), 42);	// fGblUDELAY25 * (1.0/10000.0)
	fSUMP20 = fP93 + fUDELAY17;
	fLIMIT_RANGE11 = fSUMP20;
	for (;;) {
		if (fLIMIT_RANGE11 >= _IQ24(1))
			fLIMIT_RANGE11 -= _IQ24(1 - 0);
		else if (fLIMIT_RANGE11 < _IQ24(0))
			fLIMIT_RANGE11 += _IQ24(1 - 0);
		else
			break;
	}
	fSIN_U5 = _IQ24sinPU(fLIMIT_RANGE11);
	fCOS_U6 = _IQ24cosPU(fLIMIT_RANGE11);
	TaskPARK(fCLARKEI, fCLARKEI_1, fSIN_U5, fCOS_U6, &fFunVar54, &fFunVar66);

	fSUM4 = ((fIdRef) >> 6) - fFunVar54;
	{	// backward Euler
		static _iq24 out_A = 0;
		fS10 = out_A + _IQ24mpyIQX(_IQ30(32.0 * Kpi_d/(Tpi_d*15000)), 35, fSUM4, 24);
		fS10 = (fS10 < _IQ24((-0.63333333333))) ? _IQ24((-0.63333333333)) : ((fS10 > _IQ24(0.6333333333)) ? _IQ24(0.6333333333) : fS10);
		out_A = fS10;
		fS10 += _IQ24mpyIQX(_IQ30(Kpi_d), 30, fSUM4, 24);
		fS10 = (fS10 < _IQ24((-0.63333333333))) ? _IQ24((-0.63333333333)) : ((fS10 > _IQ24(0.6333333333)) ? _IQ24(0.6333333333) : fS10);
	}
	fZOH25 = fGblS11;
	fSUM13 = fZOH25 - fFunVar66;
	{	// backward Euler
		static _iq24 out_A = 0;
		fS12 = out_A + _IQ24mpyIQX(_IQ30(32.0 * Kpi_d/(Tpi_d*15000)), 35, fSUM13, 24);
		fS12 = (fS12 < _IQ24((-0.63333333333))) ? _IQ24((-0.63333333333)) : ((fS12 > _IQ24(0.6333333333)) ? _IQ24(0.6333333333) : fS12);
		out_A = fS12;
		fS12 += _IQ24mpyIQX(_IQ30(Kpi_d), 30, fSUM13, 24);
		fS12 = (fS12 < _IQ24((-0.63333333333))) ? _IQ24((-0.63333333333)) : ((fS12 > _IQ24(0.6333333333)) ? _IQ24(0.6333333333) : fS12);
	}
	TaskIPARK(fS10, fS12, fSIN_U5, fCOS_U6, &fFunVar56, &fFunVar59);

	fADC1_15 = _IQ28mpyIQX(PSM_AdcGetValBySoc(6), 12, _IQ30((Kadc_v * 3.3)), 30);    // Get DC value from ADC_B7.
	fZOH29 = fADC1_15;
	fMULT11 = _IQ24mpyIQX(fFunVar56, 24, fZOH29, 28);
	fMULT12 = _IQ24mpyIQX(fFunVar59, 24, fZOH29, 28);
	{
		_iq24	a, b, c, vMin, vMax, temp1, temp2;
		temp1 = _IQ24mpyIQX(_IQ30(0.5/1.7320508), 30, fMULT11, 24);
		temp2 = _IQ24mpyIQX(_IQ30(0.86602540/1.7320508), 30, fMULT12, 24);
		a = temp1 << 1; // ab2uvw
		b = temp2 - temp1;
		c = -(temp1 + temp2);
		if (a > b) {
			vMin = b;
			vMax = a;
		} else {
			vMin = a;
			vMax = b;
		}
		if (c > vMax)
			vMax = c;
		if (c < vMin)
			vMin = c;
		temp1 = (vMin >> 1) + (vMax >> 1);
		fSVGEN = ((a - temp1) << 1);
		fSVGEN_1 = ((b - temp1) << 1);
		fSVGEN_2 = ((c - temp1) << 1);
	}
#ifdef	_DEBUG
	fGblVTa_p = fSVGEN;
#endif

#ifdef	_DEBUG
	fGblVTb_p = fSVGEN_1;
#endif

#ifdef	_DEBUG
	fGblVTc_p = fSVGEN_2;
#endif

#ifdef	_DEBUG
	fGblid = fFunVar54;
#endif
#ifdef	_DEBUG
	fGbliq = fFunVar66;
#endif
	fADC1_11 = _IQ28mpyIQX(PSM_AdcGetValBySoc(3), 12, _IQ30((Kadc_v * 3.3)), 30);    // Get DC value from ADC_B3.
	fZOH33 = fADC1_11;
	fm = _IQ30(0.496092); // V_A_offset
	fSUM9 = ((fZOH33) >> 4) - ((fm) >> 6);
	fCOS_U5 = _IQ24cosPU(fLIMIT_RANGE11);
#ifdef	_DEBUG
	fGblCosin = fCOS_U5;
#endif
	fSIN_U6 = _IQ24sinPU(fLIMIT_RANGE11);
#ifdef	_DEBUG
	fGblSine = fSIN_U6;
#endif
	fP91 = _IQ24mpyIQX(fUDELAY33, 24, _IQ13(140000), 13);	// fUDELAY33 * 140000
	fMULT43 = _IQ24mpyIQX(fUDELAY37, 24, fGblP80, 24);
	fSUM27 = fP91 - fMULT43;
	{
		static _iq24 out_A = _IQ24(0);
		static _iq24 in_A = 0;
		fI_RESET_I_D6 = out_A + _IQ24mpyIQX((fSUM27 >> 1) + (in_A >> 1), 24 - 1, _IQ30(8192.0 * 0.5/15000), 43);
		if (fI_RESET_I_D6 > _IQ24(1000)) {
			fI_RESET_I_D6 -= _IQ24(1000) - _IQ24((-1000));
		} else if (fI_RESET_I_D6 < _IQ24((-1000))) {
			fI_RESET_I_D6 += _IQ24(1000) - _IQ24((-1000));
		}
		out_A = fI_RESET_I_D6; in_A = fSUM27;
	}
	fZOH50 = fI_RESET_I_D6;
	fP70 = _IQ24mpyIQX(fZOH50, 24, _IQ30((-1)), 30);	// fZOH50 * (-1)
	fMULT47 = _IQ24mpyIQX(fP70, 24, fCOS_U5, 24);
	fP92 = _IQ24mpyIQX(fUDELAY39, 24, _IQ13(140000), 13);	// fUDELAY39 * 140000
	fMULT46 = _IQ24mpyIQX(fUDELAY41, 24, fGblP83, 24);
	fSUMP36 = fP92 + fMULT46;
	{
		static _iq24 out_A = _IQ24(0);
		static _iq24 in_A = 0;
		fI_RESET_I_D7 = out_A + _IQ24mpyIQX((fSUMP36 >> 1) + (in_A >> 1), 24 - 1, _IQ30(8192.0 * 0.5/15000), 43);
		if (fI_RESET_I_D7 > _IQ24(1000)) {
			fI_RESET_I_D7 -= _IQ24(1000) - _IQ24((-1000));
		} else if (fI_RESET_I_D7 < _IQ24((-1000))) {
			fI_RESET_I_D7 += _IQ24(1000) - _IQ24((-1000));
		}
		out_A = fI_RESET_I_D7; in_A = fSUMP36;
	}
	fZOH51 = fI_RESET_I_D7;
	fMULT48 = _IQ24mpyIQX(fZOH51, 24, fSIN_U6, 24);
	fSUM23 = fMULT47 - fMULT48;
#ifdef	_DEBUG
	fGblVerr = fSUM23;
#endif

	fKI_L = _IQ30(0.1); // 0.1
	fMULT31 = _IQ24mpyIQX(fSUM23, 24, fKI_L, 30);
	fSUMP12 = fMULT31 + fUDELAY7;
	fLIM10 = _IQsat(fSUMP12, _IQ24(300.0*6.0), _IQ24(((-300)*6.0)));
	fGblUDELAY7 = fLIM10;
	fKp_L = _IQ26(20); // 20
	fMULT30 = _IQ24mpyIQX(fSUM23, 24, fKp_L, 26);
	fSUMP16 = fMULT30 + fLIM10;
	fLIM37 = _IQsat(fSUMP16, _IQ24(300.0*6.0), _IQ24(((-300)*6.0)));
	fGblUDELAY25 = fLIM37;
	fP24 = fI_RESET_I_D7;
	fGblUDELAY29 = fP24;
	fADC1_12 = _IQ28mpyIQX(PSM_AdcGetValBySoc(4), 12, _IQ30((Kadc_v * 3.3)), 30);    // Get DC value from ADC_B4.
	fZOH34 = fADC1_12;
	fC14 = _IQ30(0.495401); // V_B_offset
	fSUM10 = ((fZOH34) >> 4) - ((fC14) >> 6);
	fADC1_13 = _IQ28mpyIQX(PSM_AdcGetValBySoc(5), 12, _IQ30((Kadc_v * 3.3)), 30);    // Get DC value from ADC_B5.
	fZOH35 = fADC1_13;
	fC15 = _IQ30(0.496448); // V_C_offset
	fSUM11 = ((fZOH35) >> 4) - ((fC15) >> 6);
	// ABC to alpha/beta transformation
	fCLARKEV = _IQ24mpyIQX(_IQ30(1.0/3.0), 30, fSUM9 - ((fSUM10) >> 1) - ((fSUM11) >> 1), (24-1));
	fCLARKEV_1 = _IQ24mpyIQX(_IQ30(0.57735027), 30, fSUM10 - fSUM11, 24); // uvw2ab
	fP72 = _IQ24mpyIQX(fCLARKEV, 24, _IQ30((1.0/(((0.0007417737*2.0)*3.14159265)*806.667))), 30);	// fCLARKEV * (1.0/(((0.0007417737*2.0)*3.14159265)*806.667))
	fP73 = _IQ24mpyIQX(fUDELAY30, 24, _IQ30(8.0 * (0.1954528/0.0007417737)/((2.0*3.14159265)*806.667)), 33);	// fUDELAY30 * (0.1954528/0.0007417737)/((2.0*3.14159265)*806.667)
	fSUM21 = fP72 - fP73;
	fP74 = _IQ24mpyIQX(fUDELAY31, 24, _IQ30((1.0/(((0.0007417737*2.0)*3.14159265)*806.667))), 30);	// fUDELAY31 * (1.0/(((0.0007417737*2.0)*3.14159265)*806.667))
	fSUM22 = fSUM21 - fP74;
	fk1 = _IQ24mpyIQX(fUDELAY32, 24, _IQ19((-4000)), 19);	// fUDELAY32 * (-4000)
	fSUMP29 = fSUM22 + fk1;
	{
		static _iq24 out_A = _IQ24(0);
		static _iq24 in_A = 0;
		fB4 = out_A + _IQ24mpyIQX(_IQ30(8192.0 * 0.5/15000), 43, (fSUMP29 >> 1) + (in_A >> 1), 24 - 1);
		out_A = fB4;in_A = fSUMP29;
	}
#ifdef	_DEBUG
	fGblIalfa = fB4;
#endif

	fGblUDELAY30 = fB4;
	fP23 = fI_RESET_I_D6;
	fGblUDELAY31 = fP23;
	fP28 = fCLARKEI;
	fSUM24 = fB4 - fP28;
	fGblUDELAY32 = fSUM24;
	fGblUDELAY33 = fSUM24;
	fP79 = _IQ24mpyIQX(fCLARKEV_1, 24, _IQ30((1.0/(((0.0007417737*2.0)*3.14159265)*806.667))), 30);	// fCLARKEV_1 * (1.0/(((0.0007417737*2.0)*3.14159265)*806.667))
	fP75 = _IQ24mpyIQX(fUDELAY34, 24, _IQ30(8.0 * (0.1954528/0.0007417737)/((2.0*3.14159265)*806.667)), 33);	// fUDELAY34 * (0.1954528/0.0007417737)/((2.0*3.14159265)*806.667)
	fSUM12 = fP79 - fP75;
	fp1 = _IQ24mpyIQX(fUDELAY29, 24, _IQ30((1.0/(((0.0007417737*2.0)*3.14159265)*806.667))), 30);	// fUDELAY29 * (1.0/(((0.0007417737*2.0)*3.14159265)*806.667))
	fSUM25 = fSUM12 - fp1;
	fk2 = _IQ24mpyIQX(fUDELAY35, 24, _IQ19((-4000)), 19);	// fUDELAY35 * (-4000)
	fSUMP30 = fSUM25 + fk2;
	{
		static _iq24 out_A = _IQ24(0);
		static _iq24 in_A = 0;
		fB5 = out_A + _IQ24mpyIQX(_IQ30(8192.0 * 0.5/15000), 43, (fSUMP30 >> 1) + (in_A >> 1), 24 - 1);
		out_A = fB5;in_A = fSUMP30;
	}
#ifdef	_DEBUG
	fGblIbeta = fB5;
#endif

	fGblUDELAY34 = fB5;
	fP27 = fCLARKEI_1;
	fSUM26 = fB5 - fP27;
	fGblUDELAY35 = fSUM26;
	fGblUDELAY37 = fI_RESET_I_D7;
	fGblUDELAY39 = fSUM26;
	fGblUDELAY41 = fI_RESET_I_D6;
	fZOH38 = fCLARKEV_1;
	fZOH37 = fCLARKEV;
	fGblUDELAY17 = fLIMIT_RANGE11;
	// Start of changing PWM2(3ph) registers
	// Set Duty Cycle of U
#ifdef PWM_IN_CHECK
	if (fSVGEN <= _IQ24((-0.5))) {
		PWM_CMPA(4) = PWM_TBPRD(4);
	} else if (fSVGEN >= _IQ24(1 + (-0.5))) {
		PWM_CMPA(4) = 0;
	} else {
#else
	{
#endif
		_iq24 _val = _IQ24mpyIQX(_IQ24(1 + (-0.5)) - fSVGEN, 24, _IQ30(1.0/1), 30);
		PWM_CMPA(4) = _IQ1mpyIQX(PWM_TBPRD(2), 1, _val, 24);
	}
	// Set Duty Cycle of V
#ifdef PWM_IN_CHECK
	if (fSVGEN_1 <= _IQ24((-0.5))) {
		PWM_CMPA(4+1) = PWM_TBPRD(4);
	} else if (fSVGEN_1 >= _IQ24(1 + (-0.5))) {
		PWM_CMPA(4+1) = 0;
	} else {
#else
	{
#endif
		_iq24 _val = _IQ24mpyIQX(_IQ24(1 + (-0.5)) - fSVGEN_1, 24, _IQ30(1.0/1), 30);
		PWM_CMPA(4+1) = _IQ1mpyIQX(PWM_TBPRD(2), 1, _val, 24);
	}
	// Set Duty Cycle of W
#ifdef PWM_IN_CHECK
	if (fSVGEN_2 <= _IQ24((-0.5))) {
		PWM_CMPA(4+2) = PWM_TBPRD(4);
	} else if (fSVGEN_2 >= _IQ24(1 + (-0.5))) {
		PWM_CMPA(4+2) = 0;
	} else {
#else
	{
#endif
		_iq24 _val = _IQ24mpyIQX(_IQ24(1 + (-0.5)) - fSVGEN_2, 24, _IQ30(1.0/1), 30);
		PWM_CMPA(4+2) = _IQ1mpyIQX(PWM_TBPRD(2), 1, _val, 24);
	}
	// End of changing PWM2(3ph) registers
	if (nGblSciState != PSC_SCI_INITIAL) {
		_ProcSciOutput(0, fSUM6);
		_ProcSciOutput(1, fSUM9);
		_ProcSciOutput(2, fCLARKEI);
		_ProcSciOutput(3, fCLARKEI_1);
		_ProcSciOutput(4, fLIMIT_RANGE11);
		_ProcSciOutput(5, fZOH50);
		_ProcSciOutput(6, fZOH51);
		_ProcSciOutput(7, fZOH38);
		_ProcSciOutput(8, fZOH37);
	}
	PS_ExitAdcIntr(1, M__INT1);
}

void Task_1()
{
	_iq24	fZOH15, fSPIIN, fSUM5, fZOH30, fP16, fP82, fZOH52, fZOH36, fKRPM_to_PU_SF;
	_iq24	fSpeedRef_kRPM;


	fSpeedRef_kRPM = aGblSciInValue[0].dataInt32;
	fKRPM_to_PU_SF = _IQ24mpyIQX(fSpeedRef_kRPM, 24, _IQ30(4.0 * Kwr_s), 32);	// fSpeedRef_kRPM * Kwr_s
	fZOH36 = fKRPM_to_PU_SF;
	fZOH52 = fGblUDELAY25;
	fP82 = fZOH52;
	fP16 = fP82;
	fZOH30 = fP16;
	fSUM5 = fZOH36 - fZOH30;
	{	// backward Euler
		static _iq24 out_A = 0;
		fGblS11 = out_A + _IQ24mpyIQX(_IQ30(32.0 * Kpi_s/(Tpi_s*1000)), 35, fSUM5, 24);
		fGblS11 = (fGblS11 < _IQ24((-0.3000000119))) ? _IQ24((-0.3000000119)) : ((fGblS11 > _IQ24(0.3000000119)) ? _IQ24(0.3000000119) : fGblS11);
		out_A = fGblS11;
		fGblS11 += _IQ24mpyIQX(_IQ30(Kpi_s), 30, fSUM5, 24);
		fGblS11 = (fGblS11 < _IQ24((-0.3000000119))) ? _IQ24((-0.3000000119)) : ((fGblS11 > _IQ24(0.3000000119)) ? _IQ24(0.3000000119) : fGblS11);
	}
#ifdef	_DEBUG
	fGblIqref = fGblS11;
#endif

	fSPIIN = fGblSPIIN.dataInt32;
	fZOH15 = fSPIIN;
#ifdef	_DEBUG
	fGblV73 = fZOH15;
#endif
#ifdef	_DEBUG
	fGblwe = fZOH52;
#endif
	fGblP80 = _IQ24mpyIQX(fP82, 24, _IQ28(4), 28);	// fP82 * 4
	fGblP83 = _IQ24mpyIQX(fP82, 24, _IQ28(4), 28);	// fP82 * 4
#ifdef	_DEBUG
	fGblSpeedRef_pu = fZOH36;
#endif
	if (nGblSciState != PSC_SCI_INITIAL) {
		_ProcSciOutput(9, fZOH30);
	}
}

// Parameter list for PARK
void TaskPARK(_iq24 fIn0, _iq24 fIn1, _iq24 fIn2, _iq24 fIn3, _iq24 *fOut0, _iq24 *fOut1)
{
	_iq24	fPARK_MULT3, fPARK_MULT4, fPARK_MULT2, fPARK_MULT1;


	fPARK_MULT1 = _IQ24mpyIQX(fIn0, 24, fIn3, 24);
	fPARK_MULT2 = _IQ24mpyIQX(fIn1, 24, fIn2, 24);
	*fOut0 = fPARK_MULT1 + fPARK_MULT2;
	fPARK_MULT4 = _IQ24mpyIQX(fIn1, 24, fIn3, 24);
	fPARK_MULT3 = _IQ24mpyIQX(fIn0, 24, fIn2, 24);
	*fOut1 = fPARK_MULT4 - fPARK_MULT3;
}

// Parameter list for IPARK
void TaskIPARK(_iq24 fIn0, _iq24 fIn1, _iq24 fIn2, _iq24 fIn3, _iq24 *fOut0, _iq24 *fOut1)
{
	_iq24	fIPARK_MULT3, fIPARK_MULT4, fIPARK_MULT2, fIPARK_MULT1;


	fIPARK_MULT1 = _IQ24mpyIQX(fIn0, 24, fIn3, 24);
	fIPARK_MULT2 = _IQ24mpyIQX(fIn1, 24, fIn2, 24);
	*fOut0 = fIPARK_MULT1 - fIPARK_MULT2;
	fIPARK_MULT4 = _IQ24mpyIQX(fIn1, 24, fIn3, 24);
	fIPARK_MULT3 = _IQ24mpyIQX(fIn0, 24, fIn2, 24);
	*fOut1 = fIPARK_MULT4 + fIPARK_MULT3;
}

void FGetValSPIIN()
{
	/* SPIIN DataBits = 3 */
	fGblSPIIN.dataInt32 = 0;
	fGblSPIIN.dataInt32 = (PSA_SpiRecvCmd[Cr_SPIIN] & 0x70) >> 4;
}
interrupt void FSpiCmdStart0()
{
	PS_MaskIntr(M__INT13);
	// Send SPI start commands
	PS_SpiPutQue(SeqCn_SPIIN);
	PS_ExitTimer1Intr();
}


void Initialize(void)
{
	PS_SysInit(0, 10, 18);
	PS_StartStopPwmClock(0);	// Stop Pwm Clock
	PS_InitTimer(0, 0);

	// Set initial states for those GPIO/AIO output ports.
	PS_ClearDigitOutBitB((Uint32)1 << 20);	// Reset GPIO52
	PS_InitDigitOut(52);	// Initialize GPIO52
	PS_AdcInit();
	{
	    int i;
	    /* TAdcAttr: Channel No., Soc No., Trig Src, INTADC#, Window Size, Gain */
	    const TAdcAttr aryAdcInit[7] = {
			{3, 0, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_i)},
			{4, 1, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_i)},
			{5, 2, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_i)},
			{11, 3, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_v)},
			{12, 4, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_v)},
			{13, 5, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_v)},
			{15, 6, ADCTRIG_PWM4, 1, 6, 0, _IQ28(Kadc_v)}};
	    const TAdcAttr *p = aryAdcInit;
	    for (i = 0; i < 7; i++, p++) {
	        PS_SetAdcChn(p->nIntrNo, p->nChnNo, p->nSocNo, p->nTrigSrc, p->nWindSz, p->nGain);
	        if (p->nSimult) {
	            PSM_AdcSetSimult(p->nChnNo & 7);    // This channel will be sampled with the previous channel simultaneously.
	        }
	    }
	}

	PS_InitPwm3ph(2, 3, _IQ8(1.0e6/((double)fsw_d*1)), _IQ24((0.0E-6) * 1.0e6));	// pwmNo, waveType, frequency, deadtime
	PS_SetPwm3ph2AdcIntr(ePwmIntrAdc, 1, _IQ24(0));
	PS_SetPwm3ph2Vector(ePwmIntrAdc, 6, 0, Task);
	PS_SetPwm3ph2TzAct(eTZHighImpedance);
	PS_SetPwm3ph2UvwSL(_IQ24(0 * 2.0 / 1), _IQ24(0 * 2.0 / 1), _IQ24(0 * 2.0 / 1));
	PS_StartPwm3ph2();

	PS_SpiInitBBR(PSA_SpiDev, Csz_SPI_DEVICES);
	PS_SpiInit(PSA_SpiInOut, PSA_SpiQueue, Csz_SPI_QUEUE, 4);

	PS_SciInit(15, 58, 115200, 0, aGblSciOutBuf, 1024, &_ProcSciInputItem);	// Rx(GPIO15), Tx(GPIO58)

	PS_InitTimer(1,90000L);
	PS_SetTimerIntrVector(1, -1, 0, FSpiCmdStart0);
	PS_StartStopPwmClock(2);	// Start Pwm Clock, start Timer1
}


void main()
{
	Initialize();
	PS_EnableIntr();   // Enable Global interrupt INTM
	PS_EnableDbgm();
	for (;;) {
		PS_SpiTransmitCheck();
		_ProcSciWaitStart();
	}
}

